﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;
using System.Reflection;
using System.Diagnostics;

// ZabezpieczBP otrzymawszy klucz programowy wygenerowany przez niezabezpieczoną wersję programu BezpiecznyProgram.exe zabezpiecza aplikację
// usuwając z niej kod zapisany w kluczu programowym
namespace ZabezpieczBP
{
   class Program
   {
      /// <summary>
      /// Prosta funkcja wyszukująca wystąpienia tablicy bajtów wewnątrz innej tablicy. Dla wiekszych projektów można użyć szybszego algorytmu Boyer-Moore-Horspool
      /// </summary>
      /// <param name="aBufor">Tablica bajtów, w której szukamy</param>
      /// <param name="aSzukane">Szukana tablica bajtów</param>
      /// <returns></returns>
      static private int Szukaj(byte[] aBufor, byte[] aSzukane)
      {
         int indeks = -1;
         for (int i = 0; i < aBufor.Length - aSzukane.Length && indeks == -1; i++)
         {
            int j = 0;
            while (j < aSzukane.Length && aBufor[i + j] == aSzukane[j]) j++;
            if (j == aSzukane.Length)
               indeks = i;
         }
         return indeks;
      }

      /// <summary>
      /// Główna funkcja programu podmieniająca wzorzec
      /// </summary>
      static void ZmodyfikujPlik(string aPlikZabezpieczany, string aPlikZKluczemProgramowym)
      {
         // odczyt pliku zabezpieczanego
         System.IO.FileInfo fi = new System.IO.FileInfo(aPlikZabezpieczany);
         long rozmiar = fi.Length;
         byte[] zawartoscPliku = new byte[rozmiar];
         FileStream fs = File.OpenRead(aPlikZabezpieczany);
         BinaryReader reader = new BinaryReader(fs);
         zawartoscPliku = reader.ReadBytes((int)rozmiar);
         reader.Close();
         fs.Close();

         // odczyt pliku z zawartością metody
         fi = new System.IO.FileInfo(aPlikZKluczemProgramowym);
         rozmiar = fi.Length;
         byte[] zabezpieczanyKod = new byte[rozmiar];
         fs = File.OpenRead(aPlikZKluczemProgramowym);
         reader = new BinaryReader(fs);
         zabezpieczanyKod = reader.ReadBytes((int)rozmiar);
         reader.Close();
         fs.Close();
         Debug.Assert(rozmiar > 8, "Długość zabezpieczanego kodu musi wynosić conajmniej 8 bajtów");
         
         // modyfikacja zawartości - wyzerowanie zabezpieczanego kodu
         // szukamy wystąpienia ciągu instrukcji odczytanych jako kod metody, zastąpimy je kodem po zaszyfrowaniu
         int znaleziony = Szukaj(zawartoscPliku, zabezpieczanyKod);
         while (znaleziony != -1)
         {
            for (int i = znaleziony; i < znaleziony + zabezpieczanyKod.Length; i++)
               zawartoscPliku[i] = 0;
            znaleziony = Szukaj(zawartoscPliku, zabezpieczanyKod);
         }

         // zapis pliku zabezpieczanego
         FileStream fsw = File.OpenWrite(aPlikZabezpieczany);
         BinaryWriter writer = new BinaryWriter(fsw);
         writer.Write(zawartoscPliku);
         writer.Close();
         fsw.Close();

         Console.WriteLine(aPlikZabezpieczany + " został zmodyfikowany.");
      }      

      static void Main(string[] args)
      {
         // program pobiera następujące parametry:
         // plik_zabezpieczany - ścieżka do zabezpieczanego kodu
         // plik_z_kodem_zab - ścieżka do pliku z zabezpieczanym kodem - źródłowym kluczem programowym
         // Do programu w miejsce kodu zabezpieczanego zostaną wpisane zera

         if (args.Length < 2)
         {
            Console.WriteLine("Prawidłowe wywołanie: ZabezpieczBP.exe plik_zabezpieczany plik_z_kodem_zab.");
            Console.WriteLine("  plik_zabezpieczany - ścieżka do zabezpieczanego pliku.");
            Console.WriteLine("  plik_z_kodem_zab - ścieżka do pliku z zabezpieczanym kodem.");
         }
         else if (!File.Exists(args[0]))
            Console.WriteLine("Podany plik nie istnieje.");
         else
         {
            ZmodyfikujPlik(args[0], args[1]);
         }
      }
   }

}
